innGrid.getTable = function(data)
{
	var tbody = $("<tbody/>");
	
	var totalValue = 0;
	$.each(data, function(index, row) {
		if (row.label != 'Unknown')
		{
			totalValue += parseFloat(row.value);
		}
	});

	$.each(data, function(index, row) {
		tbody.append(
			$("<tr/>").append(
				$("<td/>", {
					text: row.label
				})
			).append(
				$("<td/>", {
					text: row.value
				})
			).append(
				$("<td/>", {
					text: (row.label != 'Unknown')?parseFloat(row.value/totalValue * 100).toFixed(2) + " %":''
				})
			)
		)
	});

	var table = $("<table/>", {
		class: "table table-hover"
	}).append(
		$("<thead/>").append(
			$("<tr/>").append(
				$("<th/>", {
					text: l("Country")
				})
			).append(
				$("<th/>", {
					text: l("Room Nights")
				})
			)
			.append(
				$("<th/>")
			)

		)
	).append(tbody);
	
	return table;
}

innGrid.renderReport = function(dateStart, dateEnd, groupBy, url = null) {
	
	if (dateStart != "" && dateEnd != "")
	{
		if(url){
                    var url = 'download_booking_source_csv_export';
                }else{
                    var url = 'get_geographical_data_AJAX';
                }
		$.ajax({
			type: "POST",
			url: getBaseURL() + "reports/market_segment/"+url+"/",
			data: { 
				dateStart: dateStart,
				dateEnd: dateEnd,
				groupBy: groupBy
			},
			dataType: "json",
			success: function( data ) {
				
				$("#report-data").html(innGrid.getTable(data));

				$.each(data, function(index, row) {
					if (row.label == 'Unknown')
					{
						data.splice(index,1);
						return false; // break loop after null is removed
					}
				});
				
				// Get context with jQuery - using jQuery's .get() method.
				ctx = $("#myChart").get(0).getContext("2d");
                var chartOptions = {
                    responsive : true,
                    maintainAspectRatio: true
                };
				myNewChart = new Chart(ctx).Doughnut(data, chartOptions);

				// And for a doughnut chart
				//var myDoughnutChart = new Chart(ctx[1]).Doughnut(data,options);
				
				// render the report table's body
				
			}
		});
	}


}


$(function() {

	$('#printReportButton').click(function (){
		window.print();
	});

	$("#dateStart, #dateEnd").datepicker({ dateFormat: 'yy-mm-dd' });

	var dateStart = $("#dateStart").val();
	var dateEnd = $("#dateEnd").val();
	var groupBy = $("#groupBy").val();
	
	innGrid.renderReport(dateStart, dateEnd, groupBy);

	$("#generateReport").on('click', function() {	
		var dateStart = $("#dateStart").val();
		var dateEnd = $("#dateEnd").val();
		var groupBy = $("#groupBy").val();
		
		innGrid.renderReport(dateStart, dateEnd, groupBy);
	});
        $("#downloadMarketGeoReport").on('click', function() {	
		var dateStart = $("#dateStart").val();
		var dateEnd = $("#dateEnd").val();
		var groupBy = $("#groupBy").val();
		
                window.location.href = getBaseURL() + "reports/market_segment/download_market_geographical_csv_export/"+dateStart+"/"+dateEnd+"/"+groupBy;
		innGrid.renderReport(dateStart, dateEnd, groupBy, true);
	});
});